<?php
/**
 * The public-facing functionality of the plugin.
 *
 * @link       https://www.dukeyin.com/corona-virus-data/
 * @since      1.0.0
 *
 * @package    Corona_Virus_Data
 * @subpackage Corona_Virus_Data/public
 */
/**
 * The public-facing functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the public-facing stylesheet and JavaScript.
 *
 * @package    Corona_Virus_Data
 * @subpackage Corona_Virus_Data/public
 * @author     Duke Yin <duke@dukeyin.com>
 */
class Corona_Virus_Data_Public
{
    /**
     * The ID of this plugin.
     *
     * @since    1.0.0
     * @access   private
     * @var      string    $plugin_name    The ID of this plugin.
     */
    private $plugin_name;
    /**
     * The version of this plugin.
     *
     * @since    1.0.0
     * @access   private
     * @var      string    $version    The current version of this plugin.
     */
    private $version;
    /**
     * Initialize the class and set its properties.
     *
     * @since    1.0.0
     * @param      string    $plugin_name       The name of the plugin.
     * @param      string    $version    The version of this plugin.
     */
    public function __construct($plugin_name, $version)
    {
        $this->plugin_name = $plugin_name;
        $this->version = $version;
    }
    /**
     * Register the stylesheets for the public-facing side of the site.
     *
     * @since    1.0.0
     */
    public function enqueue_styles()
    {
        /**
         * This function is provided for demonstration purposes only.
         *
         * An instance of this class should be passed to the run() function
         * defined in Corona_Virus_Data_Loader as all of the hooks are defined
         * in that particular class.
         *
         * The Corona_Virus_Data_Loader will then create the relationship
         * between the defined hooks and the functions defined in this
         * class.
         */
		wp_register_style($this->plugin_name, plugin_dir_url(__FILE__) . 'css/corona-virus-data-public.css', array(), $this->version, 'all' );
		wp_register_style('leaflet', plugin_dir_url(__FILE__) . 'css/leaflet.css');
    }
    /**
     * Register the JavaScript for the public-facing side of the site.
     *
     * @since    1.0.0
     */
    public function enqueue_scripts()
    {
        /**
         * This function is provided for demonstration purposes only.
         *
         * An instance of this class should be passed to the run() function
         * defined in Corona_Virus_Data_Loader as all of the hooks are defined
         * in that particular class.
         *
         * The Corona_Virus_Data_Loader will then create the relationship
         * between the defined hooks and the functions defined in this
         * class.
         */
        wp_register_script($this->plugin_name, plugin_dir_url(__FILE__) . 'js/corona-virus-data-public.js', array('jquery'), $this->version, false);
        wp_register_script('chart.js', plugin_dir_url(__FILE__) . 'js/Chart.min.js', array(), '3.0.0', false);
        wp_register_script('chartjs-utils', plugin_dir_url(__FILE__) . 'js/utils.js', array(), $this->version, false);
		wp_register_script('json2html', plugin_dir_url(__FILE__) . 'js/json2html.js', array(), $this->version, true);
		wp_register_script('leaflet', plugin_dir_url(__FILE__) . 'js/leaflet.js', array(), '1.6.0', true);
		wp_register_script('cov_load_map', plugin_dir_url(__FILE__) . 'js/cov-load-map.js', array(), $this->version, true);
    }
}