<?php if (!defined('ABSPATH')) die('Direct access forbidden.');
/**
 * dynamic css, generated by customizer options
 */

if ( defined( 'FW' ) ) {

    $body_bg_url = '';
    $general_box_bg_image_url = '';
    $page_box_bg_image_url = '';
    $typography = medizco_option( 'typography' );
    $body_bg = medizco_option( 'style_body_bg', '#fff' );
    $style_primary = medizco_option( 'style_primary', '' );
    $title_color = medizco_option( 'title_color', '#172541' );
    $style_primary_dark = medizco_option( 'style_primary_dark', '#333' );
    $secondary_color = medizco_option( 'secondary_color', '' );
    $general_body_box_layout = medizco_option( "general_body_box_layout" );
    $page_body_box_layout = medizco_meta_option( get_the_ID(), "page_body_box_layout" );

    $page_override_header_item     = medizco_meta_option( get_the_ID(), 'page_header_override' );
    $page_header_layout_style_item = medizco_meta_option( get_the_ID(), 'page_header_layout_style' );

    if ( isset( $general_body_box_layout["yes"] ) ) {
        $box_bg_image = $general_body_box_layout["yes"];

        if ( isset( $box_bg_image["general_body_box_bg_image"] ) ) {
            if ( is_array( $box_bg_image["general_body_box_bg_image"] ) ) {
                $general_box_bg_image_url = $box_bg_image["general_body_box_bg_image"]["url"];
            }
        }
    }

    $global_body_font = medizco_option( 'body_font' );

    Blo_Unyson_Google_Fonts::add_typography_v2( $global_body_font );
    $body_font = medizco_advanced_font_styles( $global_body_font );

    $heading_font_one = medizco_option( 'heading_font_one' );
    Blo_Unyson_Google_Fonts::add_typography_v2( $heading_font_one );
    $heading_font_one = medizco_advanced_font_styles( $heading_font_one );

    $heading_font_two = medizco_option( 'heading_font_two' );
    Blo_Unyson_Google_Fonts::add_typography_v2( $heading_font_two );
    $heading_font_two = medizco_advanced_font_styles( $heading_font_two );

    $heading_font_three = medizco_option( 'heading_font_three' );
    Blo_Unyson_Google_Fonts::add_typography_v2( $heading_font_three );
    $heading_font_three = medizco_advanced_font_styles( $heading_font_three );

    // init custom css
    $custom_css  = medizco_option( 'custom_css' );
    $output = $custom_css;

    // global style
    $output .= "
        body{ $body_font }

        h1,h2{
            $heading_font_one
        }
        h3{
            $heading_font_two
        }

        h4{
            $heading_font_three
        }";

    if ( $style_primary ):
        $output .="
            .post .entry-header .entry-title a:hover,
            .header ul.navbar-nav > li > a:hover,
            .header ul.navbar-nav > li > a.active,
            .header ul.navbar-nav > li > a:focus {
                color: $style_primary !important;
            }

            a,
            a:hover,
            .sidebar ul li a:hover,
            a code,
            .wp-block-pullquote:before,
            .wp-block-button.is-style-outline .wp-block-button__link:not(.has-text-color),
            .wp-block-button.is-style-outline .wp-block-button__link:focus:not(.has-text-color),
            .wp-block-button.is-style-outline .wp-block-button__link:active:not(.has-text-color),
            .wp-block-quote:before,
            .header-standard ul.navbar-nav > li > .dropdown-menu li a:hover,
            .header-standard ul.navbar-nav > li > .dropdown-menu li a.active {
                color: $style_primary;
            }

            @media (min-width: 992px) {
                .medizco_breadcrumblist > li:last-child,
                .medizco_breadcrumblist > li > a:hover {
                    color: $style_primary;
                }
            }

            .entry-content .page-links > .current > .page-link {
                background-color: $style_primary;
                border-color: $style_primary;
            }

            ul.navbar-nav li .dropdown-menu li a:hover,
            .xs-service .xs-service-box .xs-service-box-info .xs-title a:hover,
            .recent-folio-menu ul li.active,
            .xs-footer .footer-widget ul li a:hover,
            .copyright span a,
            .xs-latest-news .single-latest-news .single-news-content .ts-post-title a:hover,
            .xs-top-bar .top-bar .header-nav-right-info li i.fa,
            .xs-nav-classic .header-nav-right-info li i,
            .sidebar .widget .media-body .entry-title a:hover,
            .header ul.navbar-nav li .dropdown-menu li a:hover,
            .header ul.navbar-nav li .dropdown-menu li a.active,
            .btn:hover,
            .readmore-btn-area a,
            .post .entry-header .entry-title a:hover,
             .wp-block-quote:before
            .woocommerce ul.products li.product .price,.woocommerce ul.products li.product .woocommerce-loop-product__title:hover,
            .wp-block-quote:before {
                color: $style_primary;
            }

            .header ul.navbar-nav li .dropdown-menu,
            .btn-primary,
            .recent-folio-menu ul li.active,
            .copyright .footer-social ul li a:hover,
            .testimonial-footer:after,
            .btn-border-dark:hover,
            .ts-working-box:hover .working-icon-wrapper,
            .header ul.navbar-nav > li:hover > a:before, .header ul.navbar-nav > li.active > a:before,
            .blog-post-comment .comment-respond .comment-form .form-control:focus,
            .qutoe-form-inner.ts-qoute-form .form-control:focus,
            .sidebar .widget.widget_search .form-control:focus {
                border-color: $style_primary;
            }

            .recent-folio-menu ul li.active:after,
            .ts-latest-news .single-latest-news {
                border-bottom-color: $style_primary;
            }

            .nav-classic .main-logo a:after {
                border-top-color: $style_primary;
            }

            blockquote.wp-block-quote,
            .wp-block-quote,
            .wp-block-quote:not(.is-large):not(.is-style-large),
            .wp-block-pullquote blockquote,
            blockquote.wp-block-pullquote,
            .wp-block-quote.is-large,
            .wp-block-quote.is-style-large {
                border-left-color: $style_primary;
            }

            .single-intro-text .count-number, .sticky.post .meta-featured-post,
            .sidebar .widget .widget-title:before, .pagination li.active a, .pagination li:hover a,
            .pagination li.active a:hover, .pagination li:hover a:hover,
            .sidebar .widget.widget_search .input-group-btn, .tag-lists a:hover, .tagcloud a:hover,
            .BackTo, .ticket-btn.btn:hover,
            .navbar-container .navbar-light .navbar-nav > li > a:before,
            .nav-button,
            .btn-primary,
            .single-recent-work .link-more,
            .ts-team-slider .owl-nav .owl-prev:hover i, .ts-team-slider .owl-nav .owl-next:hover i,
            .ts-footer-info-box,
            .copyright .footer-social ul li a:hover,
            .btn-border-dark:hover,
            .nav-classic .main-logo a:before,
            .btn,
            .main-logo,
            .hero-area.owl-carousel.owl-theme .owl-nav [class*=owl-]:hover,
            .post .post-footer .readmore,
            .post .post-media .video-link-btn a,
            .woocommerce ul.products li.product .button,.woocommerce ul.products li.product .added_to_cart, .woocommerce nav.woocommerce-pagination ul li a:focus, .woocommerce nav.woocommerce-pagination ul li a:hover, .woocommerce nav.woocommerce-pagination ul li span.current, .woocommerce #respond input#submit.alt, .woocommerce a.button.alt, .woocommerce button.button.alt, .woocommerce input.button.alt, .woocommerce ul.products li.product span.onsale, .woocommerce span.onsale,
            .header .navbar-toggler {
                background: $style_primary;
            }

            .page_banner_content,
            .wp-block-button .wp-block-button__link:not(.has-background) {
                background-color: $style_primary;
            }

            .header ul.navbar-nav li .dropdown-menu li a:hover,
            .header ul.navbar-nav li .dropdown-menu li a.active {
                color: #fff;
                background-color: $style_primary;
            }

            .wp-block-button.is-style-outline .wp-block-button__link:not(.has-text-color),
            .wp-block-button.is-style-outline .wp-block-button__link:focus:not(.has-text-color),
            .wp-block-button.is-style-outline .wp-block-button__link:active:not(.has-text-color) {
              border-color: $style_primary;
            }

            .owl-carousel.owl-loaded .owl-nav .owl-next.disabled,
            .owl-carousel.owl-loaded .owl-nav .owl-prev.disabled,
            .xs-about-image-wrapper.owl-carousel.owl-theme .owl-nav [class*=owl-]:hover {
                background-color: $style_primary !important;

            }";
    endif;

    if ( $style_primary ):
        $output .="
            .entry-header .entry-title a,
            h1,h2,h3,h4,h5,h6,
            .post .entry-header .entry-title a{
                color: $title_color;

            }";
    endif;

    if ( $secondary_color ):
        $output .= "
            .medizco_breadcrumblist > .curves:before,
            .medizco_breadcrumblist > .curves:after {
                background-image: -webkit-gradient(linear, left top, left bottom, from($secondary_color), to(rgba(255, 255, 255, 0)));
                background-image: -webkit-linear-gradient(top, $secondary_color 0%, rgba(255, 255, 255, 0) 100%);
                background-image: -o-linear-gradient(top, $secondary_color 0%, rgba(255, 255, 255, 0) 100%);
                background-image: linear-gradient(to bottom, $secondary_color 0%, rgba(255, 255, 255, 0) 100%);
            }
            .wp-block-button.is-style-outline .wp-block-button__link:hover {
                color: $secondary_color;
            }

            .btn-primary:hover,
            .post .post-footer .readmore:hover{
                background: $secondary_color;
                border-color: $secondary_color;
            }
            .btn:hover{
                color: #fff;
                background:$secondary_color;
                border-color: $secondary_color;
            }

            .wp-block-button:not(.is-style-outline) .wp-block-button__link:not([tabindex]):hover,
            .wp-block-button:not(.is-style-outline) .wp-block-button__link:not([tabindex]):focus {
                background-color: $secondary_color;
            }

            .wp-block-button.is-style-outline .wp-block-button__link:hover {
                border-color: $secondary_color;
            }

            .woocommerce #respond input#submit.alt:hover,
            .woocommerce a.button.alt:hover,
            .woocommerce button.button.alt:hover,
            .woocommerce input.button.alt:hover {
                background-color: $secondary_color;
            }";
    endif;

    // Footer Style
    $footer_bg_color = medizco_option( 'footer_bg_color', '' );
    $footer_copyright_color = medizco_option('footer_copyright_color', '');
    $footer_bg_option = medizco_option('footer_style');
    $footer_bg_url = 'background-image:url('.MEDIZCO_IMG.'/footer_bg.jpg'.');';

    if ( $page_body_box_layout == "yes" ) {
        $body_bg_url = 'background-image:url('. $general_box_bg_image_url .');';
    }


    if ( $body_bg_url ):
        $output .= "
            body{
            background-color: $body_bg;
                $body_bg_url
            }";
    endif;

    if ( $style_primary || $footer_bg_color ):
        $output .= "
            .footer_copyright {
                background: $style_primary;
                background: $footer_bg_color;
            }";
    endif;

    if ( $footer_copyright_color ):
        $output .= "
            .footer_copyright_text {
                color: $footer_copyright_color;
            }";
    endif;

    wp_add_inline_style( 'medizco-master', $output );
}
