<?php
/**
 * The admin-specific functionality of the plugin.
 *
 * @link       https://www.dukeyin.com/corona-virus-data/
 * @since      1.1.1
 *
 * @package    Corona_Virus_Data
 * @subpackage Corona_Virus_Data/admin
 */
/**
 * The admin-specific functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    Corona_Virus_Data
 * @subpackage Corona_Virus_Data/admin
 * @author     Duke Yin <duke@dukeyin.com>
 */

class Corona_Virus_Data_Admin {
	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;
	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $plugin_name       The name of this plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct( $plugin_name, $version ) {
		$this->plugin_name = $plugin_name;
		$this->version = $version;
	}
	/**
	 * Register the stylesheets for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_styles() {
		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Corona_Virus_Data_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Corona_Virus_Data_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */
		wp_enqueue_style( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'css/corona-virus-data-admin.css', array(), $this->version, 'all' );
	}
	/**
	 * Register the JavaScript for the admin area.
	 *
	 * @since    1.0.0
	 */
	public function enqueue_scripts() {
		/**
		 * This function is provided for demonstration purposes only.
		 *
		 * An instance of this class should be passed to the run() function
		 * defined in Corona_Virus_Data_Loader as all of the hooks are defined
		 * in that particular class.
		 *
		 * The Corona Virus Data_Loader will then create the relationship
		 * between the defined hooks and the functions defined in this
		 * class.
		 */
		wp_enqueue_script( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'js/corona-virus-data-admin.js', array( 'jquery' ), $this->version, false );
	}
}
///Admin Menu

add_action( 'admin_menu', 'cov__add_admin_menu' );
add_action( 'admin_init', 'cov__settings_init' );

function cov__add_admin_menu() {
	$covd_title = __( 'Corona Virus Data', 'corona-virus-data' );
	add_options_page( $covd_title, $covd_title, 'manage_options', 'corona-virus-data', 'cov__options_page' );
}

function cov__settings_init() { 
	register_setting( 'pluginPage', 'cov__settings' );

	add_settings_section(
		'cov__pluginPage_section', 
		__( 'Country or region to show', 'corona-virus-data' ), 
		'cov__settings_section_callback', 
		'pluginPage'
	);
	
	add_settings_field( 
		'cov__select_field_0', 
		__( 'Select country or region', 'corona-virus-data' ), 
		'cov__select_field_0_render', 
		'pluginPage', 
		'cov__pluginPage_section' 
	);
	
	add_settings_field( 
	'cov__text_field_2', 
	__( 'Map box public token', 'corona-virus-data' ), 
	'cov__text_field_2_render', 
	'pluginPage', 
	'cov__pluginPage_section' 
	);
}

function cov__select_field_0_render() { 
	$options = get_option( 'cov__settings' );
	?>
<select name='cov__settings[cov__select_field_0]' id="country_name">
<option value="China" <?php selected( $options['cov__select_field_0'] ?? '', 'China' ); ?>><?php _e('China','corona-virus-data'); ?></option>
<option value="Italy" <?php selected( $options['cov__select_field_0'] ?? '', 'Italy' ); ?>><?php _e('Italy','corona-virus-data'); ?></option>
<option value="Iran" <?php selected( $options['cov__select_field_0'] ?? '', 'Iran' ); ?>><?php _e('Iran','corona-virus-data'); ?></option>
<option value="Spain" <?php selected( $options['cov__select_field_0'] ?? '', 'Spain' ); ?>><?php _e('Spain','corona-virus-data'); ?></option>
<option value="South Korea" <?php selected( $options['cov__select_field_0'] ?? '', 'South Korea' ); ?>><?php _e('South Korea','corona-virus-data'); ?></option>
<option value="Germany" <?php selected( $options['cov__select_field_0'] ?? '', 'Germany' ); ?>><?php _e('Germany','corona-virus-data'); ?></option>
<option value="France" <?php selected( $options['cov__select_field_0'] ?? '', 'France' ); ?>><?php _e('France','corona-virus-data'); ?></option>
<option value="USA" <?php selected( $options['cov__select_field_0'] ?? '', 'USA' ); ?>><?php _e('United States','corona-virus-data'); ?></option>
<option value="Switzerland" <?php selected( $options['cov__select_field_0'] ?? '', 'Switzerland' ); ?>><?php _e('Switzerland','corona-virus-data'); ?></option>
<option value="UK" <?php selected( $options['cov__select_field_0'] ?? '', 'UK' ); ?>><?php _e('United Kingdom','corona-virus-data'); ?></option>
<option value="Netherlands" <?php selected( $options['cov__select_field_0'] ?? '', 'Netherlands' ); ?>><?php _e('Netherlands','corona-virus-data'); ?></option>
<option value="Austria" <?php selected( $options['cov__select_field_0'] ?? '', 'Austria' ); ?>><?php _e('Austria','corona-virus-data'); ?></option>
<option value="Norway" <?php selected( $options['cov__select_field_0'] ?? '', 'Norway' ); ?>><?php _e('Norway','corona-virus-data'); ?></option>
<option value="Belgium" <?php selected( $options['cov__select_field_0'] ?? '', 'Belgium' ); ?>><?php _e('Belgium','corona-virus-data'); ?></option>
<option value="Sweden" <?php selected( $options['cov__select_field_0'] ?? '', 'Sweden' ); ?>><?php _e('Sweden','corona-virus-data'); ?></option>
<option value="Denmark" <?php selected( $options['cov__select_field_0'] ?? '', 'Denmark' ); ?>><?php _e('Denmark','corona-virus-data'); ?></option>
<option value="Japan" <?php selected( $options['cov__select_field_0'] ?? '', 'Japan' ); ?>><?php _e('Japan','corona-virus-data'); ?></option>
<option value="Diamond Princess" <?php selected( $options['cov__select_field_0'] ?? '', 'Diamond Princess' ); ?>><?php _e('Diamond Princess','corona-virus-data'); ?></option>
<option value="Malaysia" <?php selected( $options['cov__select_field_0'] ?? '', 'Malaysia' ); ?>><?php _e('Malaysia','corona-virus-data'); ?></option>
<option value="Canada" <?php selected( $options['cov__select_field_0'] ?? '', 'Canada' ); ?>><?php _e('Canada','corona-virus-data'); ?></option>
<option value="Australia" <?php selected( $options['cov__select_field_0'] ?? '', 'Australia' ); ?>><?php _e('Australia','corona-virus-data'); ?></option>
<option value="Portugal" <?php selected( $options['cov__select_field_0'] ?? '', 'Portugal' ); ?>><?php _e('Portugal','corona-virus-data'); ?></option>
<option value="Qatar" <?php selected( $options['cov__select_field_0'] ?? '', 'Qatar' ); ?>><?php _e('Qatar','corona-virus-data'); ?></option>
<option value="Greece" <?php selected( $options['cov__select_field_0'] ?? '', 'Greece' ); ?>><?php _e('Greece','corona-virus-data'); ?></option>
<option value="Israel" <?php selected( $options['cov__select_field_0'] ?? '', 'Israel' ); ?>><?php _e('Israel','corona-virus-data'); ?></option>
<option value="Finland" <?php selected( $options['cov__select_field_0'] ?? '', 'Finland' ); ?>><?php _e('Finland','corona-virus-data'); ?></option>
<option value="Slovenia" <?php selected( $options['cov__select_field_0'] ?? '', 'Slovenia' ); ?>><?php _e('Slovenia','corona-virus-data'); ?></option>
<option value="Bahrain" <?php selected( $options['cov__select_field_0'] ?? '', 'Bahrain' ); ?>><?php _e('Bahrain','corona-virus-data'); ?></option>
<option value="Brazil" <?php selected( $options['cov__select_field_0'] ?? '', 'Brazil' ); ?>><?php _e('Brazil','corona-virus-data'); ?></option>
<option value="Estonia" <?php selected( $options['cov__select_field_0'] ?? '', 'Estonia' ); ?>><?php _e('Estonia','corona-virus-data'); ?></option>
<option value="Iceland" <?php selected( $options['cov__select_field_0'] ?? '', 'Iceland' ); ?>><?php _e('Iceland','corona-virus-data'); ?></option>
<option value="Pakistan" <?php selected( $options['cov__select_field_0'] ?? '', 'Pakistan' ); ?>><?php _e('Pakistan','corona-virus-data'); ?></option>
<option value="Poland" <?php selected( $options['cov__select_field_0'] ?? '', 'Poland' ); ?>><?php _e('Poland','corona-virus-data'); ?></option>
<option value="Turkey" <?php selected( $options['cov__select_field_0'] ?? '', 'Turkey' ); ?>><?php _e('Turkey','corona-virus-data'); ?></option>
<option value="Iraq" <?php selected( $options['cov__select_field_0'] ?? '', 'Iraq' ); ?>><?php _e('Iraq','corona-virus-data'); ?></option>
<option value="Syrian Arab Republic" <?php selected( $options['cov__select_field_0'] ?? '', 'Syrian Arab Republic' ); ?>><?php _e('Syrian Arab Republic','corona-virus-data'); ?></option>
<option value="Ireland" <?php selected( $options['cov__select_field_0'] ?? '', 'Ireland' ); ?>><?php _e('Ireland','corona-virus-data'); ?></option>
<option value="Luxembourg" <?php selected( $options['cov__select_field_0'] ?? '', 'Luxembourg' ); ?>><?php _e('Luxembourg','corona-virus-data'); ?></option>
<option value="Mexico" <?php selected( $options['cov__select_field_0'] ?? '', 'Mexico' ); ?>><?php _e('Mexico','corona-virus-data'); ?></option>
<option value="India" <?php selected( $options['cov__select_field_0'] ?? '', 'India' ); ?>><?php _e('India','corona-virus-data'); ?></option>
<option value="Bangladesh" <?php selected( $options['cov__select_field_0'] ?? '', 'Bangladesh' ); ?>><?php _e('Bangladesh','corona-virus-data'); ?></option>
<option value="Ecuador" <?php selected( $options['cov__select_field_0'] ?? '', 'Ecuador' ); ?>><?php _e('Ecuador','corona-virus-data'); ?></option>
<option value="Martinique" <?php selected( $options['cov__select_field_0'] ?? '', 'Martinique' ); ?>><?php _e('Martinique','corona-virus-data'); ?></option>
<option value="Argentina" <?php selected( $options['cov__select_field_0'] ?? '', 'Argentina' ); ?>><?php _e('Argentina','corona-virus-data'); ?></option>
<option value="Egypt" <?php selected( $options['cov__select_field_0'] ?? '', 'Egypt' ); ?>><?php _e('Egypt','corona-virus-data'); ?></option>
<option value="Philippines" <?php selected( $options['cov__select_field_0'] ?? '', 'Philippines' ); ?>><?php _e('Philippines','corona-virus-data'); ?></option>
<option value="Russia" <?php selected( $options['cov__select_field_0'] ?? '', 'Russia' ); ?>><?php _e('Russia','corona-virus-data'); ?></option>
<option value="Nigeria" <?php selected( $options['cov__select_field_0'] ?? '', 'Nigeria' ); ?>><?php _e('Nigeria','corona-virus-data'); ?></option>
<option value="Indonesia" <?php selected( $options['cov__select_field_0'] ?? '', 'Indonesia' ); ?>><?php _e('Indonesia','corona-virus-data'); ?></option>
<option value="Peru" <?php selected( $options['cov__select_field_0'] ?? '', 'Peru' ); ?>><?php _e('Peru','corona-virus-data'); ?></option>
<option value="Congo" <?php selected( $options['cov__select_field_0'] ?? '', 'Congo' ); ?>><?php _e('Congo - Kinshasa','corona-virus-data'); ?></option>
<option value="Colombia" <?php selected( $options['cov__select_field_0'] ?? '', 'Colombia' ); ?>><?php _e('Colombia','corona-virus-data'); ?></option>
<option value="Hong Kong" <?php selected( $options['cov__select_field_0'] ?? '', 'Hong Kong' ); ?>><?php _e('Hong Kong','corona-virus-data'); ?></option>
<option value="Taiwan" <?php selected( $options['cov__select_field_0'] ?? '', 'Taiwan' ); ?>><?php _e('Taiwan','corona-virus-data'); ?></option>
<option value="Thailand" <?php selected( $options['cov__select_field_0'] ?? '', 'Thailand' ); ?>><?php _e('Thailand','corona-virus-data'); ?></option>
<option value="Chile" <?php selected( $options['cov__select_field_0'] ?? '', 'Chile' ); ?>><?php _e('Chile','corona-virus-data'); ?></option>
<option value="Vietnam" <?php selected( $options['cov__select_field_0'] ?? '', 'Vietnam' ); ?>><?php _e('Vietnam','corona-virus-data'); ?></option>
<option value="Angola" <?php selected( $options['cov__select_field_0'] ?? '', 'Angola' ); ?>><?php _e('Angola','corona-virus-data'); ?></option>
<option value="Sudan" <?php selected( $options['cov__select_field_0'] ?? '', 'Sudan' ); ?>><?php _e('Sudan','corona-virus-data'); ?></option>
<option value="Saudi Arabia" <?php selected( $options['cov__select_field_0'] ?? '', 'Saudi Arabia' ); ?>><?php _e('Saudi Arabia','corona-virus-data'); ?></option>
<option value="Myanmar" <?php selected( $options['cov__select_field_0'] ?? '', 'Myanmar' ); ?>><?php _e('Myanmar','corona-virus-data'); ?></option>
<option value="Côte d'Ivoire" <?php selected( $options['cov__select_field_0'] ?? '', 'Côte d\'Ivoire' ); ?>><?php _e('Côte d\'Ivoire','corona-virus-data'); ?></option>
<option value="South Africa" <?php selected( $options['cov__select_field_0'] ?? '', 'South Africa' ); ?>><?php _e('South Africa','corona-virus-data'); ?></option>
<option value="Algeria" <?php selected( $options['cov__select_field_0'] ?? '', 'Algeria' ); ?>><?php _e('Algeria','corona-virus-data'); ?></option>
<option value="North Korea" <?php selected( $options['cov__select_field_0'] ?? '', 'North Korea' ); ?>><?php _e('North Korea','corona-virus-data'); ?></option>
<option value="Afghanistan" <?php selected( $options['cov__select_field_0'] ?? '', 'Afghanistan' ); ?>><?php _e('Afghanistan','corona-virus-data'); ?></option>
<option value="Morocco" <?php selected( $options['cov__select_field_0'] ?? '', 'Morocco' ); ?>><?php _e('Morocco','corona-virus-data'); ?></option>
<option value="Ethiopia" <?php selected( $options['cov__select_field_0'] ?? '', 'Ethiopia' ); ?>><?php _e('Ethiopia','corona-virus-data'); ?></option>
<option value="Kenya" <?php selected( $options['cov__select_field_0'] ?? '', 'Kenya' ); ?>><?php _e('Kenya','corona-virus-data'); ?></option>
<option value="Venezuela" <?php selected( $options['cov__select_field_0'] ?? '', 'Venezuela' ); ?>><?php _e('Venezuela','corona-virus-data'); ?></option>
<option value="Tanzania" <?php selected( $options['cov__select_field_0'] ?? '', 'Tanzania' ); ?>><?php _e('Tanzania','corona-virus-data'); ?></option>
<option value="Syria" <?php selected( $options['cov__select_field_0'] ?? '', 'Syria' ); ?>><?php _e('Syria','corona-virus-data'); ?></option>
<option value="Ukraine" <?php selected( $options['cov__select_field_0'] ?? '', 'Ukraine' ); ?>><?php _e('Ukraine','corona-virus-data'); ?></option>
<option value="Senegal" <?php selected( $options['cov__select_field_0'] ?? '', 'Senegal' ); ?>><?php _e('Senegal','corona-virus-data'); ?></option>
<option value="Tunisia" <?php selected( $options['cov__select_field_0'] ?? '', 'Tunisia' ); ?>><?php _e('Tunisia','corona-virus-data'); ?></option>
<option value="Libya" <?php selected( $options['cov__select_field_0'] ?? '', 'Libya' ); ?>><?php _e('Libya','corona-virus-data'); ?></option>
<option value="Uzbekistan" <?php selected( $options['cov__select_field_0'] ?? '', 'Uzbekistan' ); ?>><?php _e('Uzbekistan','corona-virus-data'); ?></option>
<option value="Cuba" <?php selected( $options['cov__select_field_0'] ?? '', 'Cuba' ); ?>><?php _e('Cuba','corona-virus-data'); ?></option>
<option value="Dominican Republic" <?php selected( $options['cov__select_field_0'] ?? '', 'Dominican Republic' ); ?>><?php _e('Dominican Republic','corona-virus-data'); ?></option>
<option value="Azerbaijan" <?php selected( $options['cov__select_field_0'] ?? '', 'Azerbaijan' ); ?>><?php _e('Azerbaijan','corona-virus-data'); ?></option>
<option value="Ghana" <?php selected( $options['cov__select_field_0'] ?? '', 'Ghana' ); ?>><?php _e('Ghana','corona-virus-data'); ?></option>
<option value="Bolivia" <?php selected( $options['cov__select_field_0'] ?? '', 'Bolivia' ); ?>><?php _e('Bolivia','corona-virus-data'); ?></option>
<option value="Kuwait" <?php selected( $options['cov__select_field_0'] ?? '', 'Kuwait' ); ?>><?php _e('Kuwait','corona-virus-data'); ?></option>
<option value="Yemen" <?php selected( $options['cov__select_field_0'] ?? '', 'Yemen' ); ?>><?php _e('Yemen','corona-virus-data'); ?></option>
<option value="Haiti" <?php selected( $options['cov__select_field_0'] ?? '', 'Haiti' ); ?>><?php _e('Haiti','corona-virus-data'); ?></option>
<option value="Romania" <?php selected( $options['cov__select_field_0'] ?? '', 'Romania' ); ?>><?php _e('Romania','corona-virus-data'); ?></option>
<option value="Cameroon" <?php selected( $options['cov__select_field_0'] ?? '', 'Cameroon' ); ?>><?php _e('Cameroon','corona-virus-data'); ?></option>
<option value="Paraguay" <?php selected( $options['cov__select_field_0'] ?? '', 'Paraguay' ); ?>><?php _e('Paraguay','corona-virus-data'); ?></option>
<option value="Lebanon" <?php selected( $options['cov__select_field_0'] ?? '', 'Lebanon' ); ?>><?php _e('Lebanon','corona-virus-data'); ?></option>
<option value="Belarus" <?php selected( $options['cov__select_field_0'] ?? '', 'Belarus' ); ?>><?php _e('Belarus','corona-virus-data'); ?></option>
<option value="Madagascar" <?php selected( $options['cov__select_field_0'] ?? '', 'Madagascar' ); ?>><?php _e('Madagascar','corona-virus-data'); ?></option>
<option value="Hungary" <?php selected( $options['cov__select_field_0'] ?? '', 'Hungary' ); ?>><?php _e('Hungary','corona-virus-data'); ?></option>
<option value="Zimbabwe" <?php selected( $options['cov__select_field_0'] ?? '', 'Zimbabwe' ); ?>><?php _e('Zimbabwe','corona-virus-data'); ?></option>
<option value="Uruguay" <?php selected( $options['cov__select_field_0'] ?? '', 'Uruguay' ); ?>><?php _e('Uruguay','corona-virus-data'); ?></option>
<option value="Mali" <?php selected( $options['cov__select_field_0'] ?? '', 'Mali' ); ?>><?php _e('Mali','corona-virus-data'); ?></option>
<option value="Guinea" <?php selected( $options['cov__select_field_0'] ?? '', 'Guinea' ); ?>><?php _e('Guinea','corona-virus-data'); ?></option>
<option value="Cambodia" <?php selected( $options['cov__select_field_0'] ?? '', 'KH' ); ?>><?php _e('Cambodia','corona-virus-data'); ?></option>
<option value="Togo" <?php selected( $options['cov__select_field_0'] ?? '', 'TG' ); ?>><?php _e('Togo','corona-virus-data'); ?></option>
<option value="Mozambique" <?php selected( $options['cov__select_field_0'] ?? '', 'Mozambique' ); ?>><?php _e('Mozambique','corona-virus-data'); ?></option>
<option value="El Salvador" <?php selected( $options['cov__select_field_0'] ?? '', 'El Salvador' ); ?>><?php _e('El Salvador','corona-virus-data'); ?></option>
<option value="Uganda" <?php selected( $options['cov__select_field_0'] ?? '', 'Uganda' ); ?>><?php _e('Uganda','corona-virus-data'); ?></option>
<option value="United Arab Emirates" <?php selected( $options['cov__select_field_0'] ?? '', 'United Arab Emirates' ); ?>><?php _e('United Arab Emirates','corona-virus-data'); ?></option>
<option value="New Zealand" <?php selected( $options['cov__select_field_0'] ?? '', 'New Zealand' ); ?>><?php _e('New Zealand','corona-virus-data'); ?></option>
<option value="Congo" <?php selected( $options['cov__select_field_0'] ?? '', 'Congo' ); ?>><?php _e('Congo - Brazzaville','corona-virus-data'); ?></option>
<option value="Zambia" <?php selected( $options['cov__select_field_0'] ?? '', 'Zambia' ); ?>><?php _e('Zambia','corona-virus-data'); ?></option>
<option value="Costa Rica" <?php selected( $options['cov__select_field_0'] ?? '', 'Costa Rica' ); ?>><?php _e('Costa Rica','corona-virus-data'); ?></option>
<option value="Panama" <?php selected( $options['cov__select_field_0'] ?? '', 'Panama' ); ?>><?php _e('Panama','corona-virus-data'); ?></option>
<option value="Kazakhstan" <?php selected( $options['cov__select_field_0'] ?? '', 'Kazakhstan' ); ?>><?php _e('Kazakhstan','corona-virus-data'); ?></option>
<option value="Bulgaria" <?php selected( $options['cov__select_field_0'] ?? '', 'Bulgaria' ); ?>><?php _e('Bulgaria','corona-virus-data'); ?></option>
<option value="Czechia" <?php selected( $options['cov__select_field_0'] ?? '', 'Czechia' ); ?>><?php _e('Czechia','corona-virus-data'); ?></option>
<option value="Burkina Faso" <?php selected( $options['cov__select_field_0'] ?? '', 'Burkina Faso' ); ?>><?php _e('Burkina Faso','corona-virus-data'); ?></option>
<option value="Armenia" <?php selected( $options['cov__select_field_0'] ?? '', 'Armenia' ); ?>><?php _e('Armenia','corona-virus-data'); ?></option>
<option value="Somalia" <?php selected( $options['cov__select_field_0'] ?? '', 'Somalia' ); ?>><?php _e('Somalia','corona-virus-data'); ?></option>
<option value="Georgia" <?php selected( $options['cov__select_field_0'] ?? '', 'Georgia' ); ?>><?php _e('Georgia','corona-virus-data'); ?></option>
<option value="Serbia" <?php selected( $options['cov__select_field_0'] ?? '', 'Serbia' ); ?>><?php _e('Serbia','corona-virus-data'); ?></option>
<option value="Tajikistan" <?php selected( $options['cov__select_field_0'] ?? '', 'Tajikistan' ); ?>><?php _e('Tajikistan','corona-virus-data'); ?></option>
<option value="Jordan" <?php selected( $options['cov__select_field_0'] ?? '', 'Jordan' ); ?>><?php _e('Jordan','corona-virus-data'); ?></option>
<option value="Liberia" <?php selected( $options['cov__select_field_0'] ?? '', 'Liberia' ); ?>><?php _e('Liberia','corona-virus-data'); ?></option>
<option value="Guatemala" <?php selected( $options['cov__select_field_0'] ?? '', 'Guatemala' ); ?>><?php _e('Guatemala','corona-virus-data'); ?></option>
<option value="Chad" <?php selected( $options['cov__select_field_0'] ?? '', 'Chad' ); ?>><?php _e('Chad','corona-virus-data'); ?></option>
<option value="Honduras" <?php selected( $options['cov__select_field_0'] ?? '', 'Honduras' ); ?>><?php _e('Honduras','corona-virus-data'); ?></option>
<option value="Jamaica" <?php selected( $options['cov__select_field_0'] ?? '', 'Jamaica' ); ?>><?php _e('Jamaica','corona-virus-data'); ?></option>
<option value="Djibouti" <?php selected( $options['cov__select_field_0'] ?? '', 'Djibouti' ); ?>><?php _e('Djibouti','corona-virus-data'); ?></option>
<option value="Nicaragua" <?php selected( $options['cov__select_field_0'] ?? '', 'Nicaragua' ); ?>><?php _e('Nicaragua','corona-virus-data'); ?></option>
<option value="Niger" <?php selected( $options['cov__select_field_0'] ?? '', 'Niger' ); ?>><?php _e('Niger','corona-virus-data'); ?></option>
<option value="Albania" <?php selected( $options['cov__select_field_0'] ?? '', 'Albania' ); ?>><?php _e('Albania','corona-virus-data'); ?></option>
<option value="Nepal" <?php selected( $options['cov__select_field_0'] ?? '', 'Nepal' ); ?>><?php _e('Nepal','corona-virus-data'); ?></option>
<option value="Mongolia" <?php selected( $options['cov__select_field_0'] ?? '', 'Mongolia' ); ?>><?php _e('Mongolia','corona-virus-data'); ?></option>
<option value="Rwanda" <?php selected( $options['cov__select_field_0'] ?? '', 'Rwanda' ); ?>><?php _e('Rwanda','corona-virus-data'); ?></option>
<option value="Kyrgyzstan" <?php selected( $options['cov__select_field_0'] ?? '', 'Kyrgyzstan' ); ?>><?php _e('Kyrgyzstan','corona-virus-data'); ?></option>
<option value="Central African Republic" <?php selected( $options['cov__select_field_0'] ?? '', 'Central African Republic' ); ?>><?php _e('Central African Republic','corona-virus-data'); ?></option>
<option value="Leone" <?php selected( $options['cov__select_field_0'] ?? '', 'Leone' ); ?>><?php _e('Leone','corona-virus-data'); ?></option>
<option value="Benin" <?php selected( $options['cov__select_field_0'] ?? '', 'Benin' ); ?>><?php _e('Benin','corona-virus-data'); ?></option>
<option value="Laos" <?php selected( $options['cov__select_field_0'] ?? '', 'Laos' ); ?>><?php _e('Laos','corona-virus-data'); ?></option>
<option value="Latvia" <?php selected( $options['cov__select_field_0'] ?? '', 'Latvia' ); ?>><?php _e('Latvia','corona-virus-data'); ?></option>
<option value="Mauritania" <?php selected( $options['cov__select_field_0'] ?? '', 'Mauritania' ); ?>><?php _e('Mauritania','corona-virus-data'); ?></option>
<option value="Oman" <?php selected( $options['cov__select_field_0'] ?? '', 'Oman' ); ?>><?php _e('Oman','corona-virus-data'); ?></option>
<option value="Turkmenistan" <?php selected( $options['cov__select_field_0'] ?? '', 'Turkmenistan' ); ?>><?php _e('Turkmenistan','corona-virus-data'); ?></option>
<option value="Croatia" <?php selected( $options['cov__select_field_0'] ?? '', 'Croatia' ); ?>><?php _e('Croatia','corona-virus-data'); ?></option>
<option value="Bosnia And Herzegovina" <?php selected( $options['cov__select_field_0'] ?? '', 'Bosnia And Herzegovina' ); ?>><?php _e('Bosnia And Herzegovina','corona-virus-data'); ?></option>
<option value="Moldova" <?php selected( $options['cov__select_field_0'] ?? '', 'Moldova' ); ?>><?php _e('Moldova','corona-virus-data'); ?></option>
<option value="Malawi" <?php selected( $options['cov__select_field_0'] ?? '', 'Malawi' ); ?>><?php _e('Malawi','corona-virus-data'); ?></option>
<option value="Eritrea" <?php selected( $options['cov__select_field_0'] ?? '', 'Eritrea' ); ?>><?php _e('Eritrea','corona-virus-data'); ?></option>
<option value="Mauritius" <?php selected( $options['cov__select_field_0'] ?? '', 'Mauritius' ); ?>><?php _e('Mauritius','corona-virus-data'); ?></option>
<option value="Gabon" <?php selected( $options['cov__select_field_0'] ?? '', 'Gabon' ); ?>><?php _e('Gabon','corona-virus-data'); ?></option>
<option value="Lithuania" <?php selected( $options['cov__select_field_0'] ?? '', 'Lithuania' ); ?>><?php _e('Lithuania','corona-virus-data'); ?></option>
<option value="Macedonia" <?php selected( $options['cov__select_field_0'] ?? '', 'Macedonia' ); ?>><?php _e('Macedonia','corona-virus-data'); ?></option>
<option value="Slovakia" <?php selected( $options['cov__select_field_0'] ?? '', 'Slovakia' ); ?>><?php _e('Slovakia','corona-virus-data'); ?></option>
<option value="Guinea-Bissau" <?php selected( $options['cov__select_field_0'] ?? '', 'Guinea-Bissau' ); ?>><?php _e('Guinea-Bissau','corona-virus-data'); ?></option>
<option value="Malta" <?php selected( $options['cov__select_field_0'] ?? '', 'Malta' ); ?>><?php _e('Malta','corona-virus-data'); ?></option>
<option value="Lesotho" <?php selected( $options['cov__select_field_0'] ?? '', 'Lesotho' ); ?>><?php _e('Lesotho','corona-virus-data'); ?></option>
<option value="Burundi" <?php selected( $options['cov__select_field_0'] ?? '', 'Burundi' ); ?>><?php _e('Burundi','corona-virus-data'); ?></option>
<option value="Brunei" <?php selected( $options['cov__select_field_0'] ?? '', 'Brunei' ); ?>><?php _e('Brunei','corona-virus-data'); ?></option>
<option value="Trinidad and Tobago" <?php selected( $options['cov__select_field_0'] ?? '', 'Trinidad and Tobago' ); ?>><?php _e('Trinidad and Tobago','corona-virus-data'); ?></option>
<option value="Papua New Guinea" <?php selected( $options['cov__select_field_0'] ?? '', 'Papua New Guinea' ); ?>><?php _e('Papua New Guinea','corona-virus-data'); ?></option>
<option value="Namibia" <?php selected( $options['cov__select_field_0'] ?? '', 'Namibia' ); ?>><?php _e('Namibia','corona-virus-data'); ?></option>
<option value="Guyana" <?php selected( $options['cov__select_field_0'] ?? '', 'Guyana' ); ?>><?php _e('Guyana','corona-virus-data'); ?></option>
<option value="Suriname" <?php selected( $options['cov__select_field_0'] ?? '', 'Suriname' ); ?>><?php _e('Suriname','corona-virus-data'); ?></option>
<option value="Timor-Leste" <?php selected( $options['cov__select_field_0'] ?? '', 'Timor-Leste' ); ?>><?php _e('Timor-Leste','corona-virus-data'); ?></option>
<option value="Bahamas" <?php selected( $options['cov__select_field_0'] ?? '', 'Bahamas' ); ?>><?php _e('Bahamas','corona-virus-data'); ?></option>
<option value="Cyprus" <?php selected( $options['cov__select_field_0'] ?? '', 'Cyprus' ); ?>><?php _e('Cyprus','corona-virus-data'); ?></option>
<option value="Sri Lanka" <?php selected( $options['cov__select_field_0'] ?? '', 'Sri Lanka' ); ?>><?php _e('Sri Lanka','corona-virus-data'); ?></option>
<option value="Botswana" <?php selected( $options['cov__select_field_0'] ?? '', 'Botswana' ); ?>><?php _e('Botswana','corona-virus-data'); ?></option>
<option value="Barbados" <?php selected( $options['cov__select_field_0'] ?? '', 'Barbados' ); ?>><?php _e('Barbados','corona-virus-data'); ?></option>
<option value="Fiji" <?php selected( $options['cov__select_field_0'] ?? '', 'Fiji' ); ?>><?php _e('Fiji','corona-virus-data'); ?></option>
<option value="Equatorial Guinea" <?php selected( $options['cov__select_field_0'] ?? '', 'Equatorial Guinea' ); ?>><?php _e('Equatorial Guinea','corona-virus-data'); ?></option>
<option value="Curacao" <?php selected( $options['cov__select_field_0'] ?? '', 'Curacao' ); ?>><?php _e('Curaçao','corona-virus-data'); ?></option>
<option value="Montenegro" <?php selected( $options['cov__select_field_0'] ?? '', 'Montenegro' ); ?>><?php _e('Montenegro','corona-virus-data'); ?></option>
<option value="Comoros" <?php selected( $options['cov__select_field_0'] ?? '', 'Comoros' ); ?>><?php _e('Comoros','corona-virus-data'); ?></option>
<option value="Cabo Verde" <?php selected( $options['cov__select_field_0'] ?? '', 'Cabo Verde' ); ?>><?php _e('Cabo Verde','corona-virus-data'); ?></option>
<option value="Maldives" <?php selected( $options['cov__select_field_0'] ?? '', 'Maldives' ); ?>><?php _e('Maldives','corona-virus-data'); ?></option>
<option value="South Sudan" <?php selected( $options['cov__select_field_0'] ?? '', 'South Sudan' ); ?>><?php _e('South Sudan','corona-virus-data'); ?></option>
<option value="Luxembourg" <?php selected( $options['cov__select_field_0'] ?? '', 'Luxembourg' ); ?>><?php _e('Luxembourg','corona-virus-data'); ?></option>
<option value="Bhutan" <?php selected( $options['cov__select_field_0'] ?? '', 'Bhutan' ); ?>><?php _e('Bhutan','corona-virus-data'); ?></option>
<option value="Swaziland" <?php selected( $options['cov__select_field_0'] ?? '', 'Swaziland' ); ?>><?php _e('Swaziland','corona-virus-data'); ?></option>
<option value="Sao Tome And Principe" <?php selected( $options['cov__select_field_0'] ?? '', 'Sao Tome And Principe' ); ?>><?php _e('Sao Tome And Principe','corona-virus-data'); ?></option>
<option value="Solomon Islands" <?php selected( $options['cov__select_field_0'] ?? '', 'Solomon Islands' ); ?>><?php _e('Solomon Islands','corona-virus-data'); ?></option>
<option value="Aruba" <?php selected( $options['cov__select_field_0'] ?? '', 'Aruba' ); ?>><?php _e('Aruba','corona-virus-data'); ?></option>
<option value="Samoa" <?php selected( $options['cov__select_field_0'] ?? '', 'Samoa' ); ?>><?php _e('Samoa','corona-virus-data'); ?></option>
<option value="Andorra" <?php selected( $options['cov__select_field_0'] ?? '', 'Andorra' ); ?>><?php _e('Andorra','corona-virus-data'); ?></option>
<option value="Vanuatu" <?php selected( $options['cov__select_field_0'] ?? '', 'Vanuatu' ); ?>><?php _e('Vanuatu','corona-virus-data'); ?></option>
<option value="Gambia" <?php selected( $options['cov__select_field_0'] ?? '', 'Gambia' ); ?>><?php _e('Gambia','corona-virus-data'); ?></option>
<option value="Tonga" <?php selected( $options['cov__select_field_0'] ?? '', 'Tonga' ); ?>><?php _e('Tonga','corona-virus-data'); ?></option>
<option value="Saint Lucia" <?php selected( $options['cov__select_field_0'] ?? '', 'Saint Lucia' ); ?>><?php _e('Saint Lucia','corona-virus-data'); ?></option>
<option value="Monaco" <?php selected( $options['cov__select_field_0'] ?? '', 'Monaco' ); ?>><?php _e('Monaco','corona-virus-data'); ?></option>
<option value="Liechtenstein" <?php selected( $options['cov__select_field_0'] ?? '', 'Liechtenstein' ); ?>><?php _e('Liechtenstein','corona-virus-data'); ?></option>
<option value="Antigua and Barbuda" <?php selected( $options['cov__select_field_0'] ?? '', 'Antigua And Barbuda' ); ?>><?php _e('Antigua And Barbuda','corona-virus-data'); ?></option>
<option value="Grenada" <?php selected( $options['cov__select_field_0'] ?? '', 'Grenada' ); ?>><?php _e('Grenada','corona-virus-data'); ?></option>
<option value="Svalbard and Jan Mayen" <?php selected( $options['cov__select_field_0'] ?? '', 'Svalbard and Jan Mayen' ); ?>><?php _e('Svalbard and Jan Mayen','corona-virus-data'); ?></option>
<option value="Seychelles" <?php selected( $options['cov__select_field_0'] ?? '', 'Seychelles' ); ?>><?php _e('Seychelles','corona-virus-data'); ?></option>
<option value="San Marino" <?php selected( $options['cov__select_field_0'] ?? '', 'San Marino' ); ?>><?php _e('San Marino','corona-virus-data'); ?></option>
<option value="Kiribati" <?php selected( $options['cov__select_field_0'] ?? '', 'Kiribati' ); ?>><?php _e('Kiribati','corona-virus-data'); ?></option>
<option value="Marshall Islands" <?php selected( $options['cov__select_field_0'] ?? '', 'Marshall Islands' ); ?>><?php _e('Marshall Islands','corona-virus-data'); ?></option>
<option value="Dominica" <?php selected( $options['cov__select_field_0'] ?? '', 'Dominica' ); ?>><?php _e('Dominica','corona-virus-data'); ?></option>
<option value="Saint Kitts and Nevis" <?php selected( $options['cov__select_field_0'] ?? '', 'Saint Kitts and Nevis' ); ?>><?php _e('Saint Kitts and Nevis','corona-virus-data'); ?></option>
<option value="Belize" <?php selected( $options['cov__select_field_0'] ?? '', 'Belize' ); ?>><?php _e('Belize','corona-virus-data'); ?></option>
<option value="American Samoa" <?php selected( $options['cov__select_field_0'] ?? '', 'American Samoa' ); ?>><?php _e('American Samoa','corona-virus-data'); ?></option>
<option value="Tuvalu" <?php selected( $options['cov__select_field_0'] ?? '', 'Tuvalu' ); ?>><?php _e('Tuvalu','corona-virus-data'); ?></option>
<option value="Micronesia" <?php selected( $options['cov__select_field_0'] ?? '', 'Micronesia' ); ?>><?php _e('Micronesia, Federated States Of','corona-virus-data'); ?></option>
<option value="MP" <?php selected( $options['cov__select_field_0'] ?? '', 'Northern Mariana Islands' ); ?>><?php _e('Northern Mariana Islands','corona-virus-data'); ?></option>
<option value="Guam" <?php selected( $options['cov__select_field_0'] ?? '', 'Guam' ); ?>><?php _e('Guam','corona-virus-data'); ?></option>
<option value="West Bank" <?php selected( $options['cov__select_field_0'] ?? '', 'West Bank' ); ?>><?php _e('West Bank','corona-virus-data'); ?></option>
<option value="Sint Maarten" <?php selected( $options['cov__select_field_0'] ?? '', 'Sint Maarten' ); ?>><?php _e('Sint Maarten','corona-virus-data'); ?></option>
<option value="Kosovo" <?php selected( $options['cov__select_field_0'] ?? '', 'Kosovo' ); ?>><?php _e('Kosovo','corona-virus-data'); ?></option>
<option value="Palau" <?php selected( $options['cov__select_field_0'] ?? '', 'Palau' ); ?>><?php _e('Palau','corona-virus-data'); ?></option>
<option value="Macau" <?php selected( $options['cov__select_field_0'] ?? '', 'Macau' ); ?>><?php _e('Macau','corona-virus-data'); ?></option>
<option value="Puerto Rico" <?php selected( $options['cov__select_field_0'] ?? '', 'Puerto Rico' ); ?>><?php _e('Puerto Rico','corona-virus-data'); ?></option>
<option value="Reunion" <?php selected( $options['cov__select_field_0'] ?? '', 'Reunion' ); ?>><?php _e('Reunion','corona-virus-data'); ?></option>
<option value="Gibraltar" <?php selected( $options['cov__select_field_0'] ?? '', 'Gibraltar' ); ?>><?php _e('Gibraltar','corona-virus-data'); ?></option>
<option value="Guadeloupe" <?php selected( $options['cov__select_field_0'] ?? '', 'Guadeloupe' ); ?>><?php _e('Guadeloupe','corona-virus-data'); ?></option>
<option value="French Polynesia" <?php selected( $options['cov__select_field_0'] ?? '', 'French Polynesia' ); ?>><?php _e('French Polynesia','corona-virus-data'); ?></option>
<option value="New Caledonia" <?php selected( $options['cov__select_field_0'] ?? '', 'New Caledonia' ); ?>><?php _e('New Caledonia','corona-virus-data'); ?></option>
<option value="French Guiana" <?php selected( $options['cov__select_field_0'] ?? '', 'French Guiana' ); ?>><?php _e('French Guiana','corona-virus-data'); ?></option>
<option value="Mayotte" <?php selected( $options['cov__select_field_0'] ?? '', 'Mayotte' ); ?>><?php _e('Mayotte','corona-virus-data'); ?></option>
<option value="Greenland" <?php selected( $options['cov__select_field_0'] ?? '', 'Greenland' ); ?>><?php _e('Greenland','corona-virus-data'); ?></option>
<option value="Faroe Islands" <?php selected( $options['cov__select_field_0'] ?? '', 'Faroe Islands' ); ?>><?php _e('Faroe Islands','corona-virus-data'); ?></option>
<option value="Wallis And Futuna" <?php selected( $options['cov__select_field_0'] ?? '', 'Wallis And Futuna' ); ?>><?php _e('Wallis And Futuna','corona-virus-data'); ?></option>
<option value="Saint Helena, Ascension and Tristan da Cunha" <?php selected( $options['cov__select_field_0'] ?? '', 'Saint Helena, Ascension and Tristan da Cunha' ); ?>><?php _e('Saint Helena, Ascension and Tristan da Cunha','corona-virus-data'); ?></option>
<option value="Bermuda" <?php selected( $options['cov__select_field_0'] ?? '', 'Bermuda' ); ?>><?php _e('Bermuda','corona-virus-data'); ?></option>
<option value="Turks And Caicos Islands" <?php selected( $options['cov__select_field_0'] ?? '', 'Turks And Caicos Islands' ); ?>><?php _e('Turks And Caicos Islands','corona-virus-data'); ?></option>
<option value="Cayman Islands" <?php selected( $options['cov__select_field_0'] ?? '', 'Cayman Islands' ); ?>><?php _e('Cayman Islands','corona-virus-data'); ?></option>
<option value="Cook Islands" <?php selected( $options['cov__select_field_0'] ?? '', 'Cook Islands' ); ?>><?php _e('Cook Islands','corona-virus-data'); ?></option>
<option value="Falkland Islands" <?php selected( $options['cov__select_field_0'] ?? '', 'Falkland Islands' ); ?>><?php _e('Falkland Islands','corona-virus-data'); ?></option>
<option value="South Georgia and the South Sandwich Islands" <?php selected( $options['cov__select_field_0'] ?? '', 'South Georgia and the South Sandwich Islands' ); ?>><?php _e('South Georgia and the South Sandwich Islands','corona-virus-data'); ?></option>
</select>
	<input type="hidden" id="country_code" name="country_code">
<?php
}

function cov__text_field_2_render(  ) { 

	$options = get_option( 'cov__settings' );
	?>
	<input type='text' name='cov__settings[cov__text_field_2] ?? ""' size='90' value='<?php echo $options['cov__text_field_2'] ?? ""; ?>'>

<p>
<?php _e('For showing virus data on a map through [cov2019map].','corona-virus-data'); ?>
</p>
<p>
<?php _e('Each token has 200,000 free map requests per month, so we can\'t share one token anymore.','corona-virus-data'); ?>
</p>
<p>
<?php
$cov_mbx1 = 'https://account.mapbox.com/auth/signup/';
$cov_des1 = sprintf( wp_kses( __( 'Register an account <a href="%s" target="_blank">here</a>.', 'corona-virus-data' ), array(  'a' => array( 'href' => array(), 'target' => array() ) ) ), esc_url( $cov_mbx1 ) );
echo $cov_des1;
?>
</p>
<p>
<?php
$cov_mbx2 = 'https://account.mapbox.com/';
$cov_des2 = sprintf( wp_kses( __( 'After you registered and logged-in, the Default Public Token will be in <a href="%s" target="_blank">here</a>, copy your token and paste in the text field above, then save changes.', 'corona-virus-data' ), array(  'a' => array( 'href' => array(), 'target' =>array() ) ) ), esc_url( $cov_mbx2 ) );
echo $cov_des2;
?>
</p>

	
	<?php

}

function cov__settings_section_callback() { 
	echo __( 'Select data of country or region you want to show under global data:', 'corona-virus-data' );
}

function cov__options_page() { 
		?>
		<form action='options.php' method='post'>
			<h1><?php _e('Corona Virus Data','corona-virus-data'); ?></h1>
			<p><?php _e('API Status: ','corona-virus-data'); ?><span id= "cov_ser_st"><i class="cov-loading1"></i></span> <span id="country_selected"></span></p>
<embed src="<?php echo plugins_url('/map.svg',__FILE__); ?>" type="image/svg+xml" id="world" >
  <script>
	(function () {
      var world = document.getElementById("world");
      world.addEventListener("load", function () {
        var doc = world.getSVGDocument();
		const elements = doc.getElementsByTagName('path');
doc.querySelector('[cc="<?php echo get_option( 'cov__settings' )['cov__select_field_0']??'China';?>"]').style.fill = "#fe6553"; 
        doc.onclick = ({ target }) => {
          var g = target.closest('path'); 
		  if (!g) return;
              cc = target.getAttribute("cc") || target.parentElement.getAttribute("cc");
  [...elements].forEach(e => e.classList.remove('selected'));
  g.classList.add('selected');
          if (cc) {
            document.getElementById("country_code").value = cc;
            document.getElementById("country_name").value = cc;
            document.getElementById("country_selected").innerHTML = cc;
          }
        };
      });
    }());
  </script>
			<?php
			settings_fields( 'pluginPage' );
			do_settings_sections( 'pluginPage' );
			submit_button();
			?>
		</form>
<h2><?php _e('Shortcodes available','corona-virus-data'); ?></h2>

<p><?php _e('<code>[cov2019]</code> Showing global COVID data.','corona-virus-data'); ?></p>
<p><?php _e('<code>[cov2019contry]</code> Showing COVID data of the country or region you select.','corona-virus-data'); ?></p>
<p><?php _e('<code>[cov2019all]</code> Showing data of all countries in a table.','corona-virus-data'); ?></p>
<p><?php _e('<code>[cov2019map]</code> Showing a map with data of each country.','corona-virus-data'); ?></p>
<p><?php _e('<code>[cov2019history]</code>  A line chart showing global historical daily data.','corona-virus-data'); ?></p>
<p><?php _e('<code>[cov2019historyc]</code>  A line chart showing historical daily data of the country you select.','corona-virus-data'); ?></p>
<p><?php _e('<code>[cov2019namerica]</code> Data of North America.','corona-virus-data'); ?></p>
<p><?php _e('<code>[cov2019samerica]</code> Data of South America.','corona-virus-data'); ?></p>
<p><?php _e('<code>[cov2019europe]</code> Data of Europe.','corona-virus-data'); ?></p>
<p><?php _e('<code>[cov2019asia]</code> Data of Asia.','corona-virus-data'); ?></p>
<p><?php _e('<code>[cov2019oceania]</code> Data of Oceania.','corona-virus-data'); ?></p>
<p><?php _e('<code>[cov2019africa]</code> Data of Africa.','corona-virus-data'); ?></p>

<p><?php _e('Paste any of shortcodes above to your post or page to see the result.','corona-virus-data'); ?></p>
		<?php
}